require( "scripts/style.lua" );

TitleFont = {
  standardFont,
  28,
  BlackColor
};

BodyFont = {
  standardFont,
  20,
  BlackColor
};

ENDGAMESPEC =
{
	image = "backgrounds/largedialog",
	mask = exists("backgrounds/largedialog.mask.png");
	x = kCenter+5,
	y = kCenter-5,
	
	Bitmap
	{
		image = "backgrounds/final_reward_vicky_tony",
		mask = exists("backgrounds/final_reward_vicky_tony.mask.png"),
		x = kCenter,
		y = 30,
	},
	
	Text
	{
		name = "titletext",
		label = "endgame_title",
		font = TitleFont,
		x = 0,
		y = 230,
		w = kMax,
		h = 100,
		flags = kVAlignTop + kHAlignCenter,
	},
	
	Text
	{
		name = "bodytext",
		label = "endgame_body",
		font = BodyFont,
		x = 100,
		y = 270,
		w = kMax-100,
		h = 200,
		flags = kVAlignTop + kHAlignCenter,
	},
	
	SetStyle(ThinButtonStyle),
	Button
	{
		x = kCenter,
		y = kMax-60,
		name="ok",
		label="ok",
		type = kPush,
		command = function()
			StartClose();
		end
	},
};

MakeDialog
{
	-- Name the modal dialog
	name = "endgame",
	tTransitionWindow
	{
		x = 0, y = 0, w = kMax, h = kMax, 
		speed_in = slide_speed_in, speed_out = slide_speed_out, accel_in = slice_accel_in, accel_out = slide_accel_out,
		Bitmap(ENDGAMESPEC)
	}
}